unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, LCLType;

type

  { TForm1 }

  TForm1 = class(TForm)
    ComboBox1: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    ListBox1: TListBox;
    procedure ComboBox1KeyPress(Sender: TObject; var Key: char);
    procedure ComboBox1Select(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LoadListGroup(namefile: string);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }
procedure TForm1.LoadListGroup(namefile: string);
var
  tfile: TStringList;
  str: string;
begin
  tfile:= TStringList.Create;
  tfile.LoadFromFile(namefile);
  str:= tfile.Text;
  {$IFDEF WINDOWS}
    str:= SysToUTF8(str); // преобразование в кодировку UTF-8
  {$ENDIF}
  with ListBox1 do
  begin
    Items.Text:= str;
  end;
  tfile.Free;
  ListBox1.Sorted:= true;
end;
procedure TForm1.ComboBox1Select(Sender: TObject);
begin
  with ComboBox1 do
  begin
    Label2.Caption:='Список группы ' + Text;
    case ItemIndex of
    0: LoadListGroup('List1.txt');
    1: LoadListGroup('List2.txt');
    2: LoadListGroup('List3.txt');
    else
      ShowMessage('Группа не выбрана');
    end;
  end;
end;

procedure TForm1.ComboBox1KeyPress(Sender: TObject; var Key: char);
begin
  if Key = #13 then
  begin
    ComboBox1Select(Sender);
    Key:=#0;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ComboBox1.ItemIndex:= 0;
  ComboBox1.Style:= csDropDownList;
end;


initialization
  {$I unit1.lrs}

end.

